RequireScript("json2.js");

_traders.prototype.showNewSettlement = function(WHO) {
	var settles = [];
	for (var a = 0; a < this.players[WHO].roads.length; a++) {
		if (this.corners[this.roads[this.players[WHO].roads[a]][0]].occupied == -1) {
			settles.push(this.roads[this.players[WHO].roads[a]][0]);
		}
		if (this.corners[this.roads[this.players[WHO].roads[a]][1]].occupied == -1) {
			settles.push(this.roads[this.players[WHO].roads[a]][1]);
		}
	}
	return settles;
}

_traders.prototype.findTradeResource = function (WHAT, WHO, NUM) {
	if (NUM == undefined) {
		var have = this.howManyResource(WHAT, WHO);
		var used = 0;
		for (var i = 0; i < this.players[WHO].tradeOffer.length; i++) {
			if (this.players[WHO].tradeOffer[i] == WHAT) {
				used++;
			}
		}
		if (have > used) { return true; }
		else { return false; }
	}
	else {
		var used = 0;
		if (NUM == 0) {
			for (var i = 0; i < this.players[WHO].tradeDemand.length; i++) {
				if (this.players[WHO].tradeDemand[i] == WHAT) { used++; }
			}
		}
		else {
			for (var i = 0; i < this.players[WHO].tradeOffer.length; i++) {
				if (this.players[WHO].tradeOffer[i] == WHAT) { used++; }
			}
		}
		return used;
	}
}

_traders.prototype.findAllResource = function(WHATS, WHO) {
	var need = WHATS;
	if (this.findResource(0, need[0], WHO) && this.findResource(1, need[1], WHO) && this.findResource(2, need[2], WHO) && this.findResource(3, need[3], WHO) && this.findResource(4, need[4], WHO)) {
		return true;
	}
	else { return false; }
}

_traders.prototype.howManyResource = function (WHAT, WHO) {
	var have = 0; 
	for (var i = 0; i < this.players[WHO].resources.length; i++) {
		if (this.players[WHO].resources[i] == WHAT) { have++; }
	}
	return have;
}

_traders.prototype.findSoldiers = function(WHO) {
	var soldier = 0;
	for (var i = 0; i < this.players[WHO].d_cards.length; i++) {
		if (this.players[WHO].d_cards[i] == 0) { soldier++; }
	}
	return soldier;
}

_traders.prototype.removeResource = function(WHAT, AMOUNT, WHO) {
	var location = -1;
	for (var i = 0; i < this.players[WHO].resources.length; i++) {
		if (location == -1 && this.players[WHO].resources[i] == WHAT) {
			location = i;
		}
	}
	if (location == -1) { Abort("Error"); }
	this.players[WHO].resources.splice(location, AMOUNT);
}

_traders.prototype.findResource = function(WHAT, AMOUNT, WHO) {
	var have = 0;
	for (var i = 0 ; i < this.players[WHO].resources.length; i++) {
		if (this.players[WHO].resources[i] == WHAT) { have++; }
	}	
	if (have >= AMOUNT) { return true; }
	else { return false; }
}

_traders.prototype.occupyNeighbour = function(WHERE) {
	var neighbour = [];
	for (var i in this.roads) {
		if (this.roads[i][0] == WHERE || this.roads[i][1] == WHERE) {
			if (this.roads[i][0] == WHERE) neighbour.push(this.roads[i][1]);
			if (this.roads[i][1] == WHERE) neighbour.push(this.roads[i][0]);
		}
	}
	for (var i in neighbour) {
		this.corners[neighbour[i]].occupied = 9;
	}
}

_traders.prototype.reset = function() {
	this.lastKey = 0;
	for (var i = 0; i < this.players.length; i++) {
		this.players[i].resources.sort(compareNumbers);
		this.players[i].d_cards.sort(compareNumbers);
	}
}

_traders.prototype.findNearBoat = function(WHO) {//fix
	var boats = [];	
	for (var a = 0; a < this.players[WHO].roads.length; a++) {
		var r = this.players[WHO].roads[a];
		if (this.roads[this.players[WHO].roads[a]][3]) {
			for (var b = 0; b < this.roads.length; b++) {
				if ((this.roads[b][0] == this.roads[r][0] && this.roads[b][2] == -1) || (this.roads[b][1] == this.roads[r][0] && this.roads[b][2] == -1)) {
					if (this.corners[this.roads[r][0]].occupied == this.players[WHO].id || this.corners[this.roads[r][0]].occupied == -1 || this.corners[this.roads[r][0]].occupied == 9) {
						boats.push([this.roads[b][0], this.roads[b][1], b]);
					}
				}
				if ((this.roads[b][0] == this.roads[r][1] && this.roads[b][2] == -1) || (this.roads[b][1] == this.roads[r][1] && this.roads[b][2] == -1)) {
					if (this.corners[this.roads[r][1]].occupied == this.players[WHO].id || this.corners[this.roads[r][1]].occupied == -1 || this.corners[this.roads[r][1]].occupied == 9) {
							boats.push([this.roads[b][0], this.roads[b][1], b]);
					}
				}
			}
		}
	}	
	for (var j in this.roads) {
		for (var i = 0; i < this.players[WHO].settlements.length; i++) {
			if (this.roads[j][0] == this.players[WHO].settlements[i] || this.roads[j][1] == this.players[WHO].settlements[i]) {
				if (this.roads[j][2] == -1) { //not occupied road beside a settlement.
					//make sure the 'boat' isn't already picked up from an adjoining road list. (avoid having road-to-boat).
					var duplicate = false;
					for (var k = 0; k < boats.length; k++) {
						if (boats[k][2] == j) { duplicate = true; }
					}
					if (!duplicate) { boats.push([this.roads[j][0], this.roads[j][1], j]); }
				}
			}
		}
		for (var i = 0; i < this.players[WHO].cities.length; i++) {
			if (this.roads[j][0] == this.players[WHO].cities[i] || this.roads[j][1] == this.players[WHO].cities[i]) {
				if (this.roads[j][2] == -1) { //not occupied road beside a city
					//make sure the 'boat' isn't already picked up from an adjoining road list. (avoid having road-to-boat).
					var duplicate = false;
					for (var k = 0; k < boats.length; k++) {
						if (boats[k][2] == j) { duplicate = true; }
					}
					if (!duplicate) { boats.push([this.roads[j][0], this.roads[j][1], j]); }
				}
			}
		}
	}
	
	return boats;
}

_traders.prototype.findNearRoad = function(WHO) {
	var roads = [];
	if (!this.started) {
		var corner = this.players[WHO].settlements[this.players[WHO].settlements.length - 1];
		for (var i = 0; i < this.roads.length; i++) {
			if (this.roads[i][0] == corner || this.roads[i][1] == corner) {
				if (this.roads[i][2] == -1) { roads.push(i); } //roads.push([this.roads[i][0], this.roads[i][1], i]); }
			}
		}
	}
	else {
		for (var i = 0; i < this.roads.length; i++) {
			if (this.roads[i][2] == -1) { //if the road is available
				var usable = false;
				for (var j = 0; j < this.players[WHO].roads.length; j++) {
					var corner = this.players[WHO].roads[j];
					if (this.roads[i][0] == this.roads[corner][0] || this.roads[i][0] == this.roads[corner][1] || this.roads[i][1] == this.roads[corner][0] || this.roads[i][1] == this.roads[corner][1]) {
						usable = true;
					}
				}
				for (var j = 0; j < this.players[WHO].settlements.length; j++) {
					var corner = this.players[WHO].settlements[j];
					if (this.roads[i][0] == corner || this.roads[i][1] == corner) {
						usable = true;
					}
				}
				for (var j = 0; j < this.players[WHO].cities.length; j++) {
					var corner = this.players[WHO].cities[j];
					if (this.roads[i][0] == corner || this.roads[i][1] == corner) {
						usable = true;
					}
				}
				if (usable) {
					//roads.push([this.roads[i][0], this.roads[i][1], i]);
					roads.push(i);
				}
			}
		}
	}	
	return roads;
}

_traders.prototype.updateChat = function() {
	if (this.inChat || this.inDebug) {
		Rectangle(10,0,990,364,this.color[16]);
		Line(10, 0, 1000, 0, this.color[15]);
		Line(10,0,10,364,this.color[15]);
		Line(1000,0,1000,364,this.color[15]);
		Line(10,364,1000,364,this.color[15]);
		Rectangle(10,375,990,20,this.color[16]);
		Line(10,375,1000,375,this.color[15]);
		Line(10,375,10,395,this.color[15]);
		Line(1000,375,1000,395,this.color[15]);
		Line(10,395,1000,395,this.color[15]);
		
		for (var i in this.chat.text) {
			if (this.chat.text[i] != "") {
				if (this.players[this.chat.id[i]].currentColor != undefined) { var pColor = this.color[this.pieceColors[this.players[this.chat.id[i]].currentColor]]; }
				else { var pColor = this.color[1]; }
				if (pColor == this.color[0]) { pColor = this.color[1]; }
				this.font.setColorMask(pColor);
				this.font.drawText(10,0 + (i * 12), this.chat.text[i]);
			}
		}
		this.font.setColorMask(this.color[1]);
		var shownText = "";
		var cloneText = this.chat.input;
		while(this.font.getStringWidth(cloneText) > 923) { cloneText = cloneText.substr(1); }
		this.font.drawText(12, 376, "Message: " + cloneText);
	}
	else {
		for (var i = 0; i < 7; i++) {
			var num = 23 + i;
			if (this.chat.smallText[num] != "") {
				if (this.players[this.chat.smallId[num]].currentColor != undefined) { var pColor = this.color[this.pieceColors[this.players[this.chat.smallId[num]].currentColor]]; }
				else { var pColor = this.color[1]; }
				if (pColor == this.color[0]) { pColor = this.color[1]; }
				this.font.setColorMask(pColor);
				this.font.drawText(768,5 + (i * 12), this.chat.smallText[num]);
			}
		}
	}	
}

_traders.prototype.addChat = function(ID,NAME,TEXT) {
	if (ID != 3) {
		var lines = [];
		var input = TEXT + " ";
		input = TEXT.split(" ");
		var current = NAME + ":";
		var nameWidth = this.font.getStringWidth(current);
		while (input.length > 0) {
			if (this.font.getStringWidth(current + " " + input[0]) < 409) { //room in the line
				if (current != "") { current += " " + input.shift(); }
				else { current += input.shift(); }
			}
			else { //no room, start next line.
				lines.push(current);
				current = input.shift();
			}
		}
		lines.push(current);
		for (var i = 0; i < lines.length; i++) {
			this.chat.smallText.push(lines[i]);
			this.chat.smallText.shift();
			this.chat.smallId.push(ID);
			this.chat.smallId.shift();
		}
		var lines = [];
		var input = TEXT + " ";
		input = TEXT.split(" ");
		var current = NAME + ":";
		var nameWidth = this.font.getStringWidth(current);
		while (input.length > 0) {
			if (this.font.getStringWidth(current + " " + input[0]) < 986) { //room in the line
				if (current != "") { current += " " + input.shift(); }
				else { current += input.shift(); }
			}
			else { //no room, start next line.
				lines.push(current);
				current = input.shift();
			}
		}
		lines.push(current);
		for (var i = 0; i < lines.length; i++) {
			this.chat.text.push(lines[i]);
			this.chat.text.shift();
			this.chat.id.push(ID);
			this.chat.id.shift();
		}
	}
	else if (ID == 3 && this.inDebug) {
		this.chat.text.push("DEBUG: " + TEXT + "= " + eval(TEXT));
		this.chat.text.shift();
		this.chat.id.push(this.id);
		this.chat.id.shift();
		this.chat.smallText.push("DEBUG: " + TEXT + "= " + eval(TEXT));
		this.chat.smallText.shift();
		this.chat.smallId.push(this.id);
		this.chat.smallId.shift();
	}
	else {
		this.chat.text.push(NAME + ": " + TEXT);
		this.chat.text.shift();
		this.chat.id.push(ID);
		this.chat.id.shift();
		this.chat.smallText.push(NAME + ": " + TEXT);
		this.chat.smallText.shift();
		this.chat.smallId.push(ID);
		this.chat.smallId.shift();
	}
}

_traders.prototype.initialize = function() {
	this.hex = [];
	for (var x = 0; x < 86; x++) {
		this.hex[x] = new Object;
		this.hex[x].x = 0;
		this.hex[x].y = 0;
		this.hex[x].image = 6;
		this.hex[x].robber = false;
		this.hex[x].showNumber = false;
		this.hex[x].number = -1;
		this.hex[x].port = -1;
		this.hex[x].id = x;
	}
	
	var times = 0;
	for (var i = 0; i < 10; i++) {
		for(var j = 0; j < 9; j++) {
			if (times == 87) { break; }
			if ((j % 2) == 1 && j != 0) { var p = 35; }
			else { var p = 0; }
			var print = false;
			if ((j%2)== 1){ //rows that are offseted to the right.
				if (i < 9) {	
					if (this.hex[times] == undefined) Abort(i + " " + j + " " + times);		
					this.hex[times].x = 10 + p + (i*69);
					this.hex[times].y = 10 + (j*59);
					print = true;
					//road.blit(8+p+(i*69),40+(j*59));
					//road.rotateBlit(60+p+(i*69),12+(j*59),DegreesToRadians(300));
					//road.rotateBlit(26+p+(i*69),12+(j*59),DegreesToRadians(60));
				}
			}
			else {
				if (this.hex[times] == undefined) Abort(i + " " + j + " " + times);
				this.hex[times].x = 10 + p + (i*69);
				this.hex[times].y = 10 + (j * 59);
				print = true;
				//road.blit(8+p+(i*69),40+(j*59));
				//road.rotateBlit(60+p+(i*69),12+(j*59),DegreesToRadians(300));
				//road.rotateBlit(26+p+(i*69),12+(j*59),DegreesToRadians(60));
			}
			if (print) times+= 1;
		}
	}
	this.corners = [];
	for (var i = 0; i < this.hex.length; i++) { 
		this.corners.push({
				x: this.hex[i].x + 35, y: this.hex[i].y, occupied: -1, tiles: [], port: -1, });
		this.corners.push({
				x: this.hex[i].x + 1, y: this.hex[i].y+20, occupied: -1, tiles: [], port: -1, });
		this.corners.push({
				x: this.hex[i].x + 1, y: this.hex[i].y+58, occupied: -1, tiles: [], port: -1, });
	}
	for (var i = 81; i < 86; i++) {
		this.corners.push( {
			x:  this.hex[i].x + 68, y: this.hex[i].y + 20, occupied: -1, tiles: [], port: -1, });
		this.corners.push({ 
			x: this.hex[i].x + 68, y: this.hex[i].y + 58, occupied: -1, tiles: [], port: -1, });
		this.corners.push({
			x: this.hex[i].x + 35, y: this.hex[i].y + 78, occupied: -1, tiles: [], port: -1, });
	}
	for (var i = 8; i < 89; i+=9) {
		this.corners.push({
			x: this.hex[i].x + 35, y: this.hex[i].y + 78, occupied: -1, tiles: [], port: -1, });
	}
	this.corners2 = [];
	for (var i = 0; i < this.corners.length; i++) {
		var dupe = false;
		for (var j = 0; j < this.corners2.length; j++) {
			if (isWithin(this.corners[i].x, this.corners2[j].x, 10) && isWithin(this.corners[i].y, this.corners2[j].y, 10)) {
				dupe = true;
			}
		}
		if (!dupe) { 
			this.corners2.push({
				x: this.corners[i].x, y: this.corners[i].y, occupied: -1, tiles: [], port: -1, });
		}
	}
	this.corners = this.corners2;
	
	this.roads = [];
	for (var i = 0; i < this.corners.length; i++) {
		for (var j = 0; j < this.corners.length; j++) {
			if (i != j) {
				if (isWithin(this.corners[i].x, this.corners[j].x, 36) && isWithin(this.corners[i].y, this.corners[j].y, 45)) {
					this.roads.push([i, j, -1, false]);
				}
			}
		}
	}
	var roads2 = [];
	for (var i = 0; i < this.roads.length; i++) {
		var dupe = false;
		for (var j = 0; j < roads2.length; j++) {
			if ((this.roads[i][0] == roads2[j][0] && this.roads[i][1] == roads2[j][1]) || (this.roads[i][1] == roads2[j][0] && this.roads[i][0] == roads2[j][1])) {
				dupe = true;
			}
		}
		if (!dupe) {
			roads2.push([this.roads[i][0], this.roads[i][1], -1, false]);
		}
	}
	this.roads = roads2;
	for (var i = 0; i < this.roads.length; i++) {
		if (this.corners[this.roads[i][0]].x > this.corners[this.roads[i][1]].x) { 
			var left = this.roads[i][1]; var right = this.roads[i][0];
			this.roads[i] = [left, right, -1, false];
		}
		else if (this.corners[this.roads[i][0]].x == this.corners[this.roads[i][1]].x && this.corners[this.roads[i][0]].y > this.corners[this.roads[i][1]].y) {
			var left = this.roads[i][1]; var right = this.roads[i][0];
			this.roads[i] = [left, right, -1, false];
		}
	}
}

function isWithin(a, b, x) {
	if (Math.abs(a - b) < x) return true;
	else return false;
}


function getRandom(min, max) {  
  return Math.floor(Math.random() * (max - min + 1)) + min;  
} 

_traders.prototype.setResources = function() {
	for (var i = 0; i < this.hex.length; i++) {
		var x1 = this.hex[i].x - 5;
		var x2 = this.hex[i].x + 58;
		var y1 = this.hex[i].y - 5;
		var y2 = this.hex[i].y + 51;
		for (var j = 0; j < this.corners.length; j++) {
			if (this.corners[j].x > x1 && this.corners[j].x < x2 && this.corners[j].y > y1 && this.corners[j].y < y2) {
				this.corners[j].tiles.push(this.hex[i]);
			}
		}
	}
}

_traders.prototype.findCornersOnHex = function(HEX) {
	var corners = [];	
	var x = this.hex[HEX].x - 5;
	var y = this.hex[HEX].y - 5;
	var x2 = this.hex[HEX].x + 75;
	var y2 = this.hex[HEX].y + 85;
	for (var i = 0; i < this.corners.length; i++) {
		if (this.corners[i].x > x && this.corners[i].x < x2 && this.corners[i].y > y && this.corners[i].y < y2) {
			corners.push(i);
		}
	}
	return corners;
}

function compareNumbers(a, b) 
{
  if(a > b)
    return 1;
  if(a < b)
    return -1;
  return 0;
}

_traders.prototype.tradeBank = function(WHO)
{
	this.bank = new Object();
	this.bank.reply = "no"; this.bank.demand = []; this.bank.offer = [];
	if (this.players[WHO].tradeDemand.length > 0 && this.players[WHO].tradeOffer.length > 0)
	{
		this.bank.reply = "yes";
		this.bank.offer.push(this.players[WHO].tradeDemand[0]);
		var have = -1;
		for (var i in this.havePorts)
		{
			if (this.havePorts[i] == 5) //3 for 1
			{
				this.bank.demand = [];
				this.bank.demand.push(this.players[WHO].tradeOffer[0],this.players[WHO].tradeOffer[0],this.players[WHO].tradeOffer[0]);
				have = 0;
			}
			else if (this.havePorts[i] == this.players[WHO].tradeOffer[0]) //2 for 1
			{
				this.bank.demand = [];
				this.bank.demand.push(this.players[WHO].tradeOffer[0],this.players[WHO].tradeOffer[0]);
				have = 0;
			}
		}
		if (have == -1) //no port
		{
			this.bank.demand.push(this.players[WHO].tradeOffer[0],this.players[WHO].tradeOffer[0],this.players[WHO].tradeOffer[0],this.players[WHO].tradeOffer[0]);
		}
	}
	else
	{
		if (this.players[WHO].tradeDemand.length > 0) //player demand, no player offer.
		{
			this.bank.reply = "yes";
			this.bank.offer.push(this.players[WHO].tradeDemand[0]);
			var have = -1;
			var offer = 0;
			if (offer == this.players[WHO].tradeDemand[0]) { offer++; }
			for (var i in this.havePorts)
			{
				if (this.havePorts[i] == 5) //3:1
				{
					this.bank.demand = [];
					this.bank.demand.push(offer, offer, offer);
					have = 0;
				}
				else if (this.havePorts[i] != this.players[WHO].tradeDemand[0])
				{
					this.bank.demand = [];
					this.bank.demand.push(this.havePorts[i], this.havePorts[i]);
					have = 0;
				}
			}
			if (have == -1)
			{
				this.bank.demand.push(offer, offer, offer, offer);
			}
		}
		else if (this.players[WHO].tradeOffer.length > 0) //player offered, no player demand
		{
			var playerDemand = 0;
			if (playerDemand == this.players[WHO].tradeOffer[0]) { playerDemand++; } //don't bank offer players' demand
			this.bank.offer.push(playerDemand);
			for (var i in this.havePorts)
			{
				if (this.havePorts[i] == 5) //3:1
				{
					this.bank.demand = [];
					this.bank.demand.push(this.players[WHO].tradeOffer[0], this.players[WHO].tradeOffer[0], this.players[WHO].tradeOffer[0]);
					have = 0;
				}
				else if (this.havePorts[i] == this.players[WHO].tradeOffer[0])
				{
					this.bank.demand = [];
					this.bank.demand.push(this.havePorts[i], this.havePorts[i]);
					have = 0;
				}
			}
			if (have == -1)
			{
				this.bank.demand.push(this.players[WHO].tradeOffer[0],this.players[WHO].tradeOffer[0],this.players[WHO].tradeOffer[0],this.players[WHO].tradeOffer[0]);
			}
		}
	}
}